function angle = calculateOrientationAngle(x1, y1, x2, y2)
    % Calculate the vector of the line segment
    vector = [x2 - x1, y2 - y1];
    % Calculate the angle with respect to the positive y-axis
    angle = atan2d(vector(2), vector(1));
    % Normalize the angle between 0 and 180
    if angle < 0
        angle = angle + 180;
    end
end
